package org.avineas.comli.test.osgi;

import org.avineas.comli.Master;
import org.avineas.comli.test.MasterAction;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;


/**
 * Tester for master. Very simple example.
 */
public class MasterTester implements Runnable {
    private Thread thread;
    private ServiceTracker tracker;
    
    MasterTester(BundleContext context) {
        // Track the masters.
        tracker = new ServiceTracker(context, Master.class.getName(), null);
        tracker.open();
        thread = new Thread(this);
        thread.start();
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            // Do 2 slaves, with ID 1 and 2
            for (int ident = 1; ident <= 2; ident++) {
                // Get a master from the tracker
                Master master = (Master) tracker.getService();
                if (master == null) {
                    System.out.println("No masters");
                    try {
                        Thread.sleep(3000);
                    } catch (InterruptedException exc) {
                        break;
                    }
                    continue;
                }
                MasterAction.doActions(master, ident);
                try {
                    Thread.sleep(1000);
                } catch (InterruptedException exc) {}
            }
        }
    }
    
    public void close() {
        thread.interrupt();
        tracker.close();
    }
}