package org.avineas.comli.test.osgi;

import java.util.Hashtable;

import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

import org.avineas.comli.Slave;
import org.avineas.comli.test.TestSlave;
import org.avineas.io.Channel;
import org.avineas.io.tcp.ServerSocketChannel;
import org.avineas.io.tcp.SocketChannel;


/**
 * Test activator. Creates a test environment within an OSGi context.
 */
public class Activator implements BundleActivator {
    private ServerSocketChannel slaves;
    private SocketChannel master;
    private ServiceRegistration slavesService;
    private ServiceRegistration masterService;
    private MasterTester tester;

    @Override
	public void start(BundleContext context) throws Exception {
        // First create the channels that are used for master and slave.
        // In practice these actions are probably done in separate bundles and
        // only one channel is created (either master or slave) depending on the
        // side of the PLC.
        slaves = new ServerSocketChannel(6111);
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        // See the package description the comli bundle for the setting of
        // these properties.
        properties.put("comli", "slave");
        properties.put("timeout", 3000);  // Default, but done for explanatory purposes
        slavesService = context.registerService(Channel.class.getName(), 
                slaves, properties);
        // The master.
        master = new SocketChannel("localhost", 6111);
        properties = new Hashtable<String, Object>();
        properties.put("comli", "master");
	    properties.put("timeout", 3000);
	    properties.put("tries", 3);    // Default, but done for explanatory purposes.
	    masterService = context.registerService(Channel.class.getName(), master, properties);
	    
	    // Create a test slave. Normally this is not done at the same
	    // time as when the channel is created because it is likely that slaves operate
	    // separate from the channels.
	    TestSlave slave = new TestSlave();
	    properties = new Hashtable<String, Object>();
	    // Again: see the package documentation of the comli bundle for details
	    properties.put("identification", 2);  // Set the identification of the slave
	    context.registerService(Slave.class.getName(), slave, properties);
	    // And create a tester to send data via a master.
	    tester = new MasterTester(context);
	}

    @Override
	public void stop(BundleContext context) throws Exception {
        tester.close();
        slavesService.unregister();
        masterService.unregister();
        master.close();
        slaves.close();
	}
}
