package org.avineas.comli.test;

import org.avineas.comli.Coder;
import org.avineas.comli.Slave;

/**
 * Test slave. Very simple example.
 */
public class TestSlave implements Slave {

    @Override
    public byte handleRequest(byte type, int startAddress, byte[] toFill) {
        if (type == 0x32) {
            // Transfer IO request.
            System.out.println("Request for address " + startAddress);
            int offset = 0;
            while (offset < toFill.length) {
                Coder.toHexBytes(1, 2, toFill, offset);
                offset += 2;
            }
            return 0x33;
        }
        return 0;
    }

    @Override
    public boolean handleTransfer(byte type, int startAddress, byte[] contents) {
        if (type == 0x33) {
            // Transfer IO.
            System.out.println("Transfer to " + startAddress);
            for (int cnt = 0; cnt < contents.length; cnt++) {
                System.out.print(Integer.toHexString(contents[cnt] & 0xff) + " ");
            }
            System.out.println();
            return true;
        }
        return false;
    }
}
