/*
 * Copyright 2012 aVineas IT Consulting
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.avineas.comli.test;

import org.avineas.comli.Master;

/**
 * Do some actions with a master.
 */
public class MasterAction {
    public static void doActions(Master master, int ident) {
        // Do a request.
        byte[] result = master.request(ident, (byte) 0x32, 100, 20);
        if (result == null) {
            System.out.println("No response from " + ident);
        }
        else {
            for (int i = 0; i < result.length; i++) {
                System.out.print(Integer.toHexString(result[i] & 0xff) + " ");
            }
            System.out.println();
        }
        // Do a transfer.
        boolean success = master.transfer(ident, (byte) 0x33, 200, new byte[20], 0, 20);
        System.out.println("Transfer: " + success);
    }
}
